/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.BuilderGzip;
import cds.allsky.Context;
import cds.fits.Fits;
import java.io.File;

public class BuilderTrim
extends BuilderGzip {
    public BuilderTrim(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TRIM;
    }

    @Override
    public boolean isAlreadyDone() {
        if (!this.context.actionPrecedeAction(Action.INDEX, Action.TILES)) {
            return false;
        }
        if (!this.context.actionPrecedeAction(Action.TILES, Action.GZIP)) {
            return false;
        }
        if (this.context.actionAlreadyDone(Action.UNTRIM) && !this.context.actionPrecedeAction(Action.TRIM, Action.UNTRIM)) {
            return false;
        }
        this.context.info("TRIM seems to be already done");
        return true;
    }

    @Override
    protected long gzip(String filename) throws Exception {
        if (!new File(filename).isFile()) {
            return 0L;
        }
        long t = System.currentTimeMillis();
        this.gzip(filename, this.compress);
        return System.currentTimeMillis() - t;
    }

    private void gzip(String file, boolean compress) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        Fits f = new Fits();
        Fits out = null;
        f.loadFITS(file);
        Fits fits = out = compress ? f.trimFactory() : f.untrimFactory();
        if (out != null) {
            out.writeFITS(file);
        }
    }
}

